/**
 * Copyright (c) 2005, Freescale Semiconductor
 * Freescale Confidential Proprietary
 *
 * File name   : fir32.c
 * Project name: Mazatlan
 *
 * Author(s)   : Jaime Herrero
 *               Luis Reynoso
 * Department  : Guadalajara Applications Laboratory - RTAC Americas
 *
 * Description : fir32 Creation and Destruction 
 *               
 * History     :
 * 05/03/2005  : Created (A19257).
 */

#include "iir32.h"
#include "Memory\memalloc.h"

struct tIir32Struct* IIR32Create( Frac32* pCoef, uint16 u16Num){
    struct tIir32Struct* pIIR;
    
  	pIIR=(struct tIir32Struct*)memalloc(sizeof( struct tIir32Struct));
  	pIIR->pIirCoef=pCoef;
 	pIIR->iIirCoefCount=u16Num;
 	pIIR->pIirHistory=(Frac32*)memalloc((u16Num-1)*sizeof(Frac32));

    pIIR->iIirHistoryCount=0;

    return pIIR;    
}
	

void IIR32Destroy( struct tIir32Struct* pIIR){
    memfree (pIIR->pIirHistory);
    memfree (pIIR);
    return;
}
